/**
  * @file <loop-functions/example/ExampleAggregationLoopFunc.h>
  *
  * @author Antoine Ligot - <aligot@ulb.ac.be>
  *
  * @package ARGoS3-AutoMoDe
  *
  * @license MIT License
  */

#ifndef EXAMPLE_AGGREGATION_LOOP_FUNC
#define EXAMPLE_AGGREGATION_LOOP_FUNC

#include <regex>
#include "../../../src/CoreLoopFunctions.h"
#include <argos3/core/simulator/space/space.h>
#include <argos3/plugins/simulator/entities/box_entity.h>
#include <argos3/plugins/simulator/entities/cylinder_entity.h>
#include <argos3/plugins/robots/e-puck/simulator/epuck_entity.h>


using namespace argos;

class ChocolateMission1LoopFunction: public CoreLoopFunctions {
  public:
    ChocolateMission1LoopFunction();
    ChocolateMission1LoopFunction(const ChocolateMission1LoopFunction& orig);
    virtual ~ChocolateMission1LoopFunction();

    virtual void Destroy();
    virtual void Init(TConfigurationNode& t_tree);
    virtual argos::CColor GetFloorColor(const argos::CVector2& c_position_on_plane);
    virtual void PostExperiment();
    virtual void PostStep();
    virtual void Reset();

    Real GetObjectiveFunction();
   // UInt32  GetNumRobots();


    /*
     * Returns a vector containing a random position inside a circle of radius
     * m_fDistributionRadius and centered in (0,0).
     */
    virtual CVector3 GetRandomPosition();
    bool IsWithinCircle(CVector2 c_cEpuckPosition, CVector2& m_cCoordSpot, Real fRadius);

    Real InnerRadious();
    void MoveObstacles();

  private:
    Real fRadius;
    Real m_fRadius;
    CVector2 m_cCoordBlackSpot;
    //std::regex m_cRegex;
    //CVector2 ep;
    //CVector2 m_cCoordWhiteSpot;
    //CVector2 m_CCoordRect1;
    //CVector2 m_CCoordRect2;
    //CVector2 m_CCoordRect2Pos;
    //CVector2 m_CCoordRect1Pos;

    //UInt32 m_unScoreSpot;
    Real m_fObjectiveFunction;
    UInt32 m_unNumberEdges;
    CBoxEntity *pcWall;
    CCylinderEntity *cylinder;
    Real sidesize;
    //bool bb;


    //UInt32 numRobots;
  //  UInt32 m_robotmin;
};

#endif
